package com.pragprog.aebook.hellochat.server;

import com.pragprog.aebook.hellochat.client.GreetingService;
import com.pragprog.aebook.hellochat.shared.FieldVerifier;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * Implementacja usługi RPC po stronie serwera. 
 */

@SuppressWarnings("serial")
public class GreetingServiceImpl extends RemoteServiceServlet implements
		GreetingService {

	public String greetServer(String input) throws IllegalArgumentException {
		if (!FieldVerifier.isValidName(input)) {
			
			throw new IllegalArgumentException(
					"Wprowadzony nick musi mieć przynajmniej cztery znaki");
		}

		String serverInfo = getServletContext().getServerInfo();
		String userAgent = getThreadLocalRequest().getHeader("User-Agent");

		input = escapeHtml(input);
		userAgent = escapeHtml(userAgent);

		return "Witaj, " + input + "!<br><br>Tu serwer. Działam na " + serverInfo
				+ ".<br><br>Wygląda na to, że Ty używasz:<br>" + userAgent;
	}


	private String escapeHtml(String html) {
		if (html == null) {
			return null;
		}
		return html.replaceAll("&", "&amp;").replaceAll("<", "&lt;")
				.replaceAll(">", "&gt;");
	}
}
